/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import net.ftb.data.User;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.ProfileAdderDialog;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.CryptoUtils;
import net.ftb.util.OSUtils;

public class UserManager {
    public static final ArrayList<User> _users = new ArrayList();
    private File _file;
    private File _oldFile;

    public UserManager(File file, File oldFile) {
        this._file = file;
        this._oldFile = oldFile;
        this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS) {
            if (this._oldFile.exists()) {
                this._oldFile.delete();
            }
            if (this._file.exists()) {
                this._file.delete();
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this._file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            for (User user : _users) {
                objectOutputStream.writeObject(user);
            }
        }
        finally {
            objectOutputStream.close();
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        if (!this._file.exists() && !this._oldFile.exists()) {
            return;
        }
        _users.clear();
        if (!OSUtils.verifyUUID()) {
            Logger.logError(I18N.getLocaleString("CHANGEDUUID"));
            ProfileAdderDialog p = new ProfileAdderDialog(LaunchFrame.getInstance(), "CHANGEDUUID", true);
            p.setVisible(true);
            return;
        }
        try {
            FileInputStream fileInputStream = this._file.exists() ? new FileInputStream(this._file) : new FileInputStream(this._oldFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            try {
                Object obj;
                while ((obj = objectInputStream.readObject()) != null) {
                    if (!(obj instanceof User)) continue;
                    _users.add((User)obj);
                }
            }
            catch (EOFException eOFException) {
            }
            finally {
                objectInputStream.close();
                fileInputStream.close();
            }
        }
        catch (StreamCorruptedException e) {
            Logger.logWarn("Failed to decode logindata. Trying old format");
        }
        catch (Exception e) {
            Logger.logError("Failed to decode logindata", e);
        }
        if (_users.isEmpty()) {
            try {
                String str;
                BufferedReader read = this._file.exists() ? new BufferedReader(new FileReader(this._file)) : new BufferedReader(new FileReader(this._oldFile));
                while ((str = read.readLine()) != null) {
                    str = CryptoUtils.decryptLegacy(str, OSUtils.getMacAddress());
                    _users.add(new User(str));
                }
                read.close();
            }
            catch (NumberFormatException ex) {
            }
            catch (Exception ex) {
                Logger.logError("Error while reading logindata", ex);
            }
            if (_users.isEmpty()) {
                Logger.logInfo("No users found after decoding old logindata format. Malformed logindata or empty logindata");
            }
        }
    }

    public static void addUser(String username, String password, String name) {
        _users.add(new User(username, password, name));
    }

    public static ArrayList<String> getUsernames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (User user : _users) {
            ret.add(user.getName());
        }
        return ret;
    }

    public static ArrayList<String> getNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (User user : _users) {
            ret.add(user.getName());
        }
        return ret;
    }

    public static String getUsername(String name) {
        for (User user : _users) {
            if (!user.getName().equals(name)) continue;
            return user.getUsername();
        }
        return "";
    }

    public static String getPassword(String name) {
        for (User user : _users) {
            if (!user.getName().equals(name)) continue;
            return user.getPassword();
        }
        return "";
    }

    private static User findUser(String name) {
        for (User user : _users) {
            if (!user.getName().equals(name)) continue;
            return user;
        }
        return null;
    }

    public static void removePass(String username) {
        for (User user : _users) {
            if (!user.getUsername().equals(username)) continue;
            user.setPassword("");
            return;
        }
    }

    public static void removeUser(String name) {
        User temp = UserManager.findUser(name);
        if (temp != null) {
            _users.remove(_users.indexOf(temp));
        }
    }

    public static void updateUser(String oldName, String username, String password, String name) {
        User temp = UserManager.findUser(oldName);
        if (temp != null) {
            _users.get(_users.indexOf(temp)).setUsername(username);
            _users.get(_users.indexOf(temp)).setPassword(password);
            _users.get(_users.indexOf(temp)).setName(name);
        }
    }

    public static void setStore(String user, String encode) {
        User temp;
        if (encode != null && !encode.isEmpty() && (temp = UserManager.findUser(user)) != null) {
            temp.setStore(encode);
        }
    }

    public static String getMojangData(String user) {
        User temp = UserManager.findUser(user);
        if (temp != null) {
            return temp.getDecryptedDatastore();
        }
        return null;
    }

    public static String getUUID(String username) {
        User temp = UserManager.findUser(username);
        if (temp != null) {
            return temp.getDecryptedDatastore();
        }
        return null;
    }

    public static void setUUID(String username, String uuid) {
        User temp = UserManager.findUser(username);
        if (temp != null) {
            temp.setUUID(uuid);
        }
    }

    public static void setSaveMojangData(String username, boolean b) {
        User temp = UserManager.findUser(username);
        if (temp != null) {
            temp.setSaveMojangData(b);
        }
    }

    public static boolean getSaveMojangData(String username) {
        User temp = UserManager.findUser(username);
        if (temp != null) {
            return temp.getSaveMojangData();
        }
        return false;
    }
}

